package kom.itbeankit.common.itbeanframe;


/*************************************************************************************
* This event is fired from an itBeanFrame, which want to tell the itBean,
* that anything was happend in the frame, e.g. the user pressed a control
* button or selected a menu item.
* @author: Abdulmotaleb El Saddik, Christian C. Hoffmann
* @version 0.5  26.06.1998
*/

public class ItBeanFrameEvent extends java.util.EventObject {
    public static final int ID_FIRST = 1000;
    public static final int NEW_FILE = ID_FIRST + 0;
	public static final int STOP = ID_FIRST + 1;
	public static final int PLAY = ID_FIRST + 2;
	public static final int PAUSE = ID_FIRST + 3;
	public static final int TOBEGIN = ID_FIRST + 4;
	public static final int FORWARDS = ID_FIRST + 5;
	public static final int BACKWARDS = ID_FIRST + 6;
	public static final int HIDE = ID_FIRST + 7;
	public static final int OPEN_URL = ID_FIRST + 8;
	public static final int SAVE = ID_FIRST + 9;
	public static final int SAVE_AS = ID_FIRST + 10;
	public static final int EXIT = ID_FIRST + 11;
	public static final int LEVEL_UP = ID_FIRST + 12;
	public static final int LEVEL_DOWN = ID_FIRST + 13;
	public static final int LANGUAGE_CHANGED = ID_FIRST + 14;
	public static final int EXPLANATION_CHANGED = ID_FIRST + 15;
	public static final int GUIDED_TOUR = ID_FIRST + 16;
    public static final int ABOUT = ID_FIRST + 17;
    public static final int ID_LAST = ID_FIRST + 18;

    protected int id;
    protected String command;

    /**
    This constructor creates an ItBeanFrameEvent with specified id
    and default command value.
    */
    public ItBeanFrameEvent(Object source, int id) {
        this(source, id, "");
    }

     /**
    This constructor creates an ItBeanFrameEvent with the specified id
    and specified command value.
    */
    public ItBeanFrameEvent(Object source, int id, String command) {
        super(source);
        this.id = id;
        this.command = command;
    }

    /**
    This method returns the command string.
    */
    public String getCommand() {
        return this.command;
    }

    /**
    This method returns the id.
    */
    public int getID() {
        return this.id;
    }
}